#ifndef _fma_fabric_h_
#define _fma_fabric_h_

/*
 * This is the FMA-private data for the fabric
 */
struct fma_fabric {
  uint32_t map_id;		/* unique ID for this map */

  int num_nics;
  struct lf_nic **nics;
  int max_nic_ports;		/* most ports on any NIC */

  /* all the links, link indices correspond to map from FMS */
  int num_links;
  union lf_node **link_end_node;
  char *link_end_port;
};
#define FMA_FABRIC(F) ((F)->user.fma)

/*
 * FMA-private struct for xbars
 */
struct fma_xbar {
  struct lf_xbar *parent;	/* useful link back to parent */

  uint32_t node_id;

  /* Persistant info about best way to reach this xbar */
  int host_dist;			/* closest NIC port on this host */
  struct fma_nic_info *host_nic;	/* which NIC is closest */
  int host_nic_port;			/* which port */
  unsigned char host_route[FMA_IFC_ROUTE_LEN];	/* the route */
  int host_in_port;			/* inbound port on this xbar */

  /*
   * some data for routing - these are per NIC port,
   * e.g.  xbar_dist[nic_index*max_ports+nic_port]
   */
#define FMA_NICPORT_INDEX(N, P) ((N)*A.myri->local_max_nic_ports+(P))
  signed char *xbar_dist;	/* distance from each NIC port */

  /*
   * private data for mapping the fabric - must persist across scheduler calls
   */
  struct fma_mf_info *mf_info;		/* per-port info */
  uint32_t mf_signature;		/* port-connect signature */
  int mf_xbar_resolved;			/* uniquely identified? */
  struct fma_sync_timer *mf_compare_timer;	/* xbar compare timer */
  int mf_compares_sent;			/* number of compare pkts sent */
  int mf_compare_stage;			/* what type of compares to send */
  int mf_compare_timeout;		/* what type of compares to send */
  int mf_compare_tries;			/* number of times compare tried */
  int mf_compare_port;			/* the port on this xbar */
  int mf_normal_delta;			/* normalization delta */

  struct fma_nic_info *mf_nic;		/* how to reach this xbar */
  int mf_nic_port;
  int mf_route_len;
  unsigned char mf_route[FMA_IFC_ROUTE_LEN];
  int mf_in_port;

  struct fma_xbar *mf_next;		/* for linking them */
  struct fma_xbar *mf_prev;
  
  /*
   * DFS routing  variables
   */
  uint8_t dfs_seen;		/* for dfs */
  uint8_t dfs_up_skip_depth;	/* skip if going up and depth >= this */
  uint8_t dfs_down_skip_depth;	/* skip if going down and depth >= this */

  int *dfs_link_load;           /* for routing algorithms*/
  char *dfs_port_order;		/* sorted port order */

  /*
   * non-persistant information - once you return to scheduler, these may 
   * change!
   */

  /* for breadth-first searches */
  int bf_serial;			/* integer serial number */
  void *bf_serialp;			/* pointer serial number */
  struct lf_xbar *bf_next;
  int bf_in_port;

  int fx_in_port;		/* fma_xbar in_port */
  unsigned char fx_route[MYRI_MAX_ROUTE_LEN];
  int fx_route_len;
};
#define FMA_XBAR(X) ((X)->user.fma)
#define FMA_XBAR_N(N) FMA_XBAR(LF_XBAR(N))

/*
 * FMA-private struct for NICs
 */
struct fma_nic {
  struct lf_nic *parent;	/* useful link back to parent */
  struct fma_nic_info *local_nip; /* link to myri nic info, NULL if non-local */

  uint32_t nic_node_id;

  /* temp holding place for host's stuff */
  enum lf_firmware_type fw_type; /* what is running on the host */
  int fma_flags;		/* flags */

  unsigned char *route_buf;	/* buffer for holding all routes */
  int8_t *route_lens; 	 	/* route lengths */

  unsigned char *dfs_route_count;

  /*
   * for mapping
   */
  struct fma_nic_info *mf_nic;		/* how to reach this NIC */
  int mf_nic_port;
  int mf_route_len;
  unsigned char mf_route[FMA_IFC_ROUTE_LEN];

  struct fma_mf_info *mf_info;
  int mf_host_index;			/* for determining unique owner */
  struct fma_nic *mf_next;		/* for linking NICs during mapping */
  struct fma_nic *mf_prev;
};
#define FMA_NIC(N) ((N)->user.fma)
#define FMA_NIC_N(N) FMA_NIC(LF_NIC(N))

/*
 * FMA-private struct for hosts
 */
struct fma_host {
  lf_mac_addr_t	max_mac_addr;	/* MAX MAC address on this host */

  int map_send_id;		/* msg ID of topo map being sent */

  int host_id;			/* a global sequential numbering of the hosts */

  /* a quick route to this host */
  uint8_t quick_route[FMA_IFC_ROUTE_LEN];
  int quick_route_len;
  struct fma_nic_info *quick_nic;	/* NIC/port for this route */
  int quick_port;
};
#define FMA_HOST(H) (((struct lf_host *)(H))->user.fma)


struct lf_fabric *fma_create_fabric();
struct lf_xbar *fma_create_xbar(int num_ports, int xbar_id, int quad_dis);
struct lf_nic *fma_create_nic(int num_ports, lf_mac_addr_t mac_addr,
    enum lf_firmware_type fw_type);
struct lf_host *fma_create_host(void);
void fma_calc_xbar_dists(void);
char *fma_mac_to_hostname(lf_mac_addr_t mac_addr);
void fma_shuffle_port_order(struct lf_xbar*xp, char*port_order);

#endif /* _fma_fabric_h_ */
